 ; Ŀ
 ;   Buexe: get subroutine headers from a directory of files, ignore       
 ;   duplicates, alphabetize.                                              
 ;   Copyright 2009 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Alpho - find the sublist in which the leading string is    
 ;   first in alphabetical order.  Numbers are converted to strings so     
 ;   that the > function doesn't crash.                                    
 ;   Argument: Nexlst, a list.                                             
 ;   Typically called by Horize.                                           
 ;   Calls nothing, returns a string.                                      
 ; 
 (DEFUN ALPHO (nexlst / num neth first)
  (setq num 0)
  (while (setq neth (nth num nexlst))
         (if (= (type neth) 'LIST) (setq neth (car neth)))
         (cond ((= (type neth) 'INT)
                (setq neth (itoa neth)))
               ((= (type neth) 'REAL)
                (setq neth (rtos neth 2 6))))
         (if (or (null first) (< neth first))
             (setq first neth))
         (setq num (1+ num)))
 first)
 ; Ŀ
 ;   Alpho end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Buexe - get subroutine headers from a lisp file.           
 ;   Arguments: Fnam, the file to process.                                 
 ;   Calls Sef and Lspace.                                                 
 ;   Returns a list of lists, one per header: (name line line ...).        
 ; 
 (DEFUN BUEXE (fnam / fn linn semlis pos chra sub malist)
 ; Ŀ
 ;   Open the input file.                                                  
 ; 
   (setq fn (open fnam "r"))
   (setq fnam (nopth fnam))
 ; Ŀ
 ;   The main loop.                                                        
 ; 
   (while (setq linn (read-line fn))           ; while there is a next line
 ; Ŀ
 ;   If the current line starts with a semicolon, add all of them until    
 ;   there is a line without one.                                          
 ; 
          (setq semlis ())
          (while (and linn (sef linn))
                 (setq semlis (cons linn semlis))
                 (setq linn (read-line fn)))
 ; Ŀ
 ;   If the next line begins with "defun" but not "defun c:" then the      
 ;   stuff in semlis is a subroutine header.                               
 ; 
          (if (and semlis linn
                   (= (strcase (substr (car (lspace linn)) 1 6) t) "(defun")
                   (/= (strcase (substr (car (lspace linn)) 1 9) t)
                                                            "(defun c:")) ;))
              (progn
 ; Ŀ
 ;   Find the subroutine name in the defun line.                           
 ; 
                   (setq linn (substr (car (lspace linn)) 8))
                   (setq pos 1)
                   (while (and (setq chra (substr linn pos 1))
                               (not (member chra '(" " "/" ")" ""))))  ; (
                          (setq pos (1+ pos)))
                   (setq linn (substr linn 1 (1- pos)))
                   (setq sub (list (strcase linn)
                                   (reverse semlis) (list fnam)))
                   (setq malist (cons sub malist)))))
  (if fn (close fn))
 malist)
 ; Ŀ
 ;   Subroutine Buexe end.                                                 
 ; 

 ; Ŀ
 ;   Delis - make a list of lists of lists ... into a single list.         
 ;   Arguments: Alist, a list.                                             
 ;   Calls only itself (recursive.)                                        
 ;   Returns a list.                                                       
 ;   Updated January 30th, 2009 - the previous version is buggy.           
 ; 
 (DEFUN DELIS (alist / sub malist)
  (while (setq sub (car alist))
         (setq alist (cdr alist))
         (if (= (type sub) 'LIST)
             (setq malist (append malist (delis sub)))
             (setq malist (append malist (list sub)))))
 malist)
 ; Ŀ
 ;   Delis end.                                                            
 ; 
 
 ; Ŀ
 ;   Glisp - get a list of all lisp file in a directory.                   
 ;   Arguments: Pref, the current directory path string.                   
 ;              Pat, a file name pattern.                                  
 ;   Returns a list of filenames with paths.                               
 ; 
 (DEFUN GLISP (pref pat / fils num fnam nulis)
 ; Ŀ
 ;   Get a list of matching files.                                         
 ; 
  (setq fils (vl-directory-files pref pat 1))
 ; Ŀ
 ;   Put the filename list in alphabetical order.                          
 ; 
  (if fils (setq fils (acad_strlsort fils)))
  (setq num 0)
  (while (and fils (setq fnam (nth num fils)))
         (setq num (1+ num))
         (setq fnam (strcat pref fnam))
         (setq nulis (cons fnam nulis)))
 (reverse nulis))
 ; Ŀ
 ;   Glisp end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Horize - put a list in alphabetical order.  If an element  
 ;   is a list it is ahphabetized by first element, numers are converted   
 ;   to strings.                                                           
 ;   Arguments: Nexlst, a list.                                            
 ;   Calls Alpho, returns the list, reordered.                             
 ; 
 (DEFUN HORIZE (nexlst / low sub neth hrzlst newlst orderd)
  (while nexlst
        (setq low (alpho nexlst))                   ; lowest leading number
        (while (and nexlst (setq sub (nth 0 nexlst)))
               (if (= (type sub) 'LIST) (setq neth (car sub)))
               (cond ((= (type neth) 'INT)
                      (setq neth (itoa neth)))
                     ((= (type neth) 'REAL)
                      (setq neth (rtos neth 2 6))))
               (if (equal low neth)
                   (setq hrzlst (append hrzlst (list sub)))
                   (setq newlst (append newlst (list sub))))
               (setq nexlst (cdr nexlst)))          ; remove 1st ent from list
        (setq orderd (append orderd hrzlst))        ; add lev sublst to levels
        (setq hrzlst ())                            ; set to () for next loop
        (setq nexlst newlst)                        ; nexlst reconstituted
        (setq newlst ()))                           ; empty new list & reuse
  orderd)
 ; Ŀ
 ;   Horize end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Lspace - kill leading and trailing spaces from a string.   
 ;   Takes one argument, a string.                                         
 ;   Returns a list: the modifiedp string and the no. of spaces removed.   
 ; 
 (DEFUN LSPACE (str / len monk)
  (setq monk 0)
  (while (and (/= str "") (= (substr str 1 1) " "))
         (setq monk (1+ monk))
         (setq str (substr str 2)))
  (while (and (/= str "") (= (substr str (setq len (strlen str))) " "))
         (setq monk (1+ monk))
         (setq str (substr str 1 (1- len))))
 (list str monk))
 ; Ŀ
 ;   Subroutine Lspace end.                                                
 ; 

 ; Ŀ
 ;   Subroutine Nopth - remove the path from a filename.                   
 ; 
 (DEFUN NOPTH (tt / pos)
  (setq pos (strlen tt))                          ; start at end of the string
  (while (< 0 pos)
         (if (or (= (substr tt pos 1) (chr 92))   ; if char = \
                 (= (substr tt pos 1) ":"))       ; if char = :
             (progn
                  (setq tt (substr tt (1+ pos)))  ; then set tt to all after
                  (setq pos 1)))                  ;  and set pos to first
         (setq pos (1- pos)))                     ; set pos to previous
 tt)
 ; Ŀ
 ;   Nopth end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Sef - see if a line begins with a semicolon.               
 ;   Argument: Linn, a text string.                                        
 ;   Returns T if a semicolon was found, else nil.                         
 ; 
 (DEFUN SEF (linn / pos sub)
  (setq pos 1)
  (while (and (setq sub (substr linn pos 1))
              (= sub " ")
              (/= sub ""))
         (setq pos (1+ pos)))
 (if (= (substr linn pos 1) ";") t))
 ; Ŀ
 ;   Subroutine Sef end.                                                   
 ; 

 ; Ŀ
 ;   Buexe.                                                                
 ; 
 (DEFUN C:BUEXE (/ pref flist fnam gnulis malist num sub1 nam1 last0 sub0
                                                      nulist nam0 fo sub)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get the current drawing path.                                         
 ; 
  (setq pref (getvar "dwgprefix"))
 ; Ŀ
 ;   Get a list of lisp files in the current directory.                    
 ; 
  (setq flist (glisp pref "*.lsp"))
 ; Ŀ
 ;   While there are filenames in the list.                                
 ; 
  (while (setq fnam (car flist))
         (setq flist (cdr flist))
         (setq gnulis (buexe fnam))
         (setq malist (append malist gnulis)))
 ; Ŀ
 ;   Now have a list of lists:                                             
 ;   (function_name (header_line line line ...) (filename))                
 ;   Want to check for duplicates and combine their filename lists.        
 ;   So alphabetise by first element in each sublist.                      
 ; 
  (setq malist (horize malist))
 ; Ŀ
 ;   And then compare and if necessary combine adjacent lists.             
 ; 
  (setq num 0)
  (while (setq sub1 (nth num malist))
         (setq nam1 (car sub1))
         (cond ((= nam0 nam1)
                (setq last0 (last sub0))
                (setq flist (append last0 (last sub1)))
                (setq sub0 (append (reverse (cdr (reverse sub0)))
                                   (list flist))))
               ((and nam0 nam1)
                (setq nulist (append nulist (list sub0)))
                (setq sub0 sub1)
                (setq nam0 nam1))
               (t
                (setq sub0 sub1)
                (setq nam0 nam1)))
         (setq num (1+ num)))
  (write-line (strcat "\nTotal Subroutines: " (itoa num)))
 ; Ŀ
 ;   Add a line feed to each header data list.                             
 ; 
  (setq malist ())
  (setq num 0)
  (while (setq sub (nth num nulist))
         (setq num (1+ num))
         (setq sub (cons "" sub))
         (setq malist (append malist (list sub))))
  (write-line (strcat "\nUniquely Named Subroutines: " (itoa num)))
 ; Ŀ
 ;   Flatten the list.                                                     
 ; 
  (setq nulist (delis malist))
 ; Ŀ
 ;   Write the list out to a text file.                                    
 ; 
  (setq fo (open "datax.txt" "w"))
  (setq num 0)
  (while (setq sub (nth num nulist))
         (setq num (1+ num))
         (write-line sub fo))
  (close fo)
 ; Ŀ
 ;   End neatly.                                                           
 ; 
 (princ))